#ifdef GL_ES
precision highp float;

varying	vec3 lightVector, halfVector;
varying vec2 vTexCoord;
varying vec2 vRotTexCoord;
#else
in vec3 lightVector, halfVector;
in vec2 vTexCoord;
in vec2 vRotTexCoord;

out vec4 fragColor;
#endif

#ifdef USE_SPECULAR
uniform sampler2D specularTex;
#else
uniform float specularCoefficient;
#endif
#ifdef USE_STATIC
uniform sampler2D staticTex;
#endif
#ifdef USE_SHADOW
uniform sampler2D shadowTex;
#endif
uniform float specularPower;
uniform float fade;

uniform sampler2D normalTex;
uniform sampler2D colorTex;

void main()
{
#ifdef GL_ES
    vec4 bumpSample = texture2D(normalTex, vRotTexCoord.st);
    vec4 tColor = texture2D(colorTex, vRotTexCoord.st);
#else
    vec4 bumpSample = texture(normalTex, vRotTexCoord.st);
    vec4 tColor = texture(colorTex, vRotTexCoord.st);
#endif
    vec3 bump = normalize(bumpSample.xyz * 2.0 - 1.0);
    
#ifdef USE_AO
    float lambert = max(0.0, dot(bump, normalize(lightVector))) * bumpSample.a;
#else
    float lambert = max(0.0, dot(bump, normalize(lightVector)));
#endif
    vec3 diffuse = tColor.rgb * lambert;
    
#ifdef USE_SPECULAR
#ifdef GL_ES
    vec4 specSample = texture2D(specularTex, vRotTexCoord.st);
#else
    vec4 specSample = texture(specularTex, vRotTexCoord.st);
#endif
    float specularCoefficient = specSample.a;
#endif
    
    float bumper = max(0.0, dot(bump, normalize(halfVector)));
#ifdef USE_AO
    float specular = /*tColor.rgb*/pow(bumper, specularPower) * specularCoefficient * bumpSample.a;
#else
    float specular = /*tColor.rgb*/pow(bumper, specularPower) * specularCoefficient;
#endif
    
#ifdef USE_SPECULAR
    vec3 specColor = specular * specSample.rgb;
#else
    vec3 specColor = vec3(specular);
#endif
    
    float colorAlpha = tColor.a * fade;
    vec4 primaryColor = vec4((specColor + diffuse) * colorAlpha, colorAlpha);
#ifdef USE_SHADOW
#ifdef GL_ES
    vec4 shadowColor = texture2D(shadowTex, vTexCoord.st) * fade;
#else
    vec4 shadowColor = texture(shadowTex, vTexCoord.st) * fade;
#endif
    vec4 outColor = primaryColor + shadowColor * (1.0 - primaryColor.a);
#else
    vec4 outColor = primaryColor;
#endif
    
#ifdef USE_STATIC
#ifdef GL_ES
    vec4 staticSample = texture2D(staticTex, vTexCoord.st) * fade;
#else
    vec4 staticSample = texture(staticTex, vTexCoord.st) * fade;
#endif
    outColor = staticSample + outColor * (1.0 - staticSample.a);
#endif

#ifdef GL_ES
    vec3 outTest = step(vec3(0.04045), outColor.rgb);
    gl_FragColor = vec4(mix(outColor.rgb / 12.92, pow((outColor.rgb + 0.055) / 1.055, vec3(2.4)), outTest), outColor.a);
#else
    fragColor = outColor;
#endif
}
